module Rubysermon
	class Cpu < ModTemplate

		def initialize
			@y_axis = "CPU Load"
			@graph_name = "CPU Load In Time"

			@cpu_count = File.readlines("/proc/stat").select { |line|
				line =~ /^cpu[\d]/
			}.length

			@cpu_load = 0.00
			@options = {notify_threshold: @cpu_count*0.90}
		end

		def load_options(options)
			@options.merge!(options)
		end

		def results
			@cpu_load = File.read("/proc/loadavg").split(" ").first.to_f
		end

		def notify?
			@cpu_load >= @options[:notify_threshold].to_i
		end

		def y_axis_name
			@y_axis
		end

		def graph_name
			"#@graph_name (CPUs: #@cpu_count)"
		end
	end
end