require_relative "rubysermon/version"
require_relative "rubysermon/mod_loader"
require_relative "rubysermon/mod_template"
require_relative "rubysermon/configurator"

module Rubysermon
	class App

		@config_path = "#{Dir.pwd}/config.json"
		@config
		@loader

		def initialize

		end

		private

		def config
			configurator = Configurator.new(@config_path)
			@config = configurator.get_settings()
		end

		def load_mod(mod_name)
			begin
				@loader = ModLoader.load mod_name
			rescue ModLoaderException => e
				$stderr = e.message
			end
		end
	end
end
