require_relative "rubysermon/version"
require_relative "rubysermon/mod_loader"
require_relative "rubysermon/mod_template"
require_relative "rubysermon/configurator"

module Rubysermon
	LIB_PATH = File.expand_path(File.dirname(__FILE__))
	APP_PATH = "#{LIB_PATH}/.."
	MOD_PATH = "#{LIB_PATH}/rubysermon/mod"

	class App

		def initialize
			@config = ""
			@loader = nil
			@config_path = "#{APP_PATH}/config.json"
		end

		private

		def config
			configurator = Configurator.new(@config_path)
			@config = configurator.get_settings()
		end

		def load_mod(mod_name)
			begin
				@loader = ModLoader.load mod_name
			rescue ModLoaderException => e
				$stderr = e.message
			end
		end
	end
end
