<?php
class Lochness extends Restaurant {

	function __construct() {
		$day = date('N');
		$row = 3*$day - 1;

		parent::__construct(
			"Lochness",
			"http://www.lochnesspub.sk/category/obedove-menu/",
			['Polievka aj zradlo' => "/html/body/div[3]/div/div/div[1]/table/tbody/tr[$row]/td[2]/text()"]
		);
	}

	/**
	 * @param DOMNodeList $parentNode
	 * @param iOutput $logger
	 * @return bool
	 */
	public function runCallbackParser($parentNode, iOutput $logger) {

		$parsed = '';

		foreach ($parentNode as $node)
		{
			$meal = trim($node->nodeValue);
			$logger->addMeal($meal);

			$parsed .= $meal;
		}

		return $parsed;
	}
}
