<?php
/**
 * Created by IntelliJ IDEA.
 * User: nosko
 * Date: 1/26/13
 * Time: 10:52 PM
 * To change this template use File | Settings | File Templates.
 */

/**
 * Class representing restaurant
 */
class Restaurant {

    private $url;
    private $name;
    private $xpaths = array();

    public function getName() {
        return $this->name;
    }

    public function getUrl() {
        return $this->url;
    }

    public function getXpaths() {
        return $this->xpaths;
    }

    /**
     * @param $name
     * @param $url
     * @param $xpaths
     */
    function __construct($name, $url, $xpaths) {

        if (empty($url) || empty($xpaths)) {
            throw new InvalidArgumentException("All argument are required");
        }

        $this->name = $name;
        $this->url = $url;

        if (is_string($xpaths)) {
            $this->xpaths[] = $xpaths;
        } else if (is_array($xpaths)) {
            $this->xpaths = $xpaths;
        } else {
            throw new InvalidArgumentException("Xpaths must be string or array");
        }
    }
}
