<?php
class Lochness extends Restaurant {

	function __construct() {
		$day = date('N');
		$row = 3*$day - 2;

		parent::__construct(
			"Lochness",
			"http://www.lochnesspub.sk/category/obedove-menu/",
			["Polievka aj zradlo" => "/html/body/div[3]/div/div/div[1]/table/tbody/tr[$row]"]
		);
	}

	public function runCallbackParser($parentNode, iOutput $logger) {
		$nodes = $parentNode->item(0)->childNodes;
		if ($nodes->item(2) === NULL)
		{
			return '';
		}

		/** @var $meals DOMNode */
		$meals = $nodes->item(2);
		$i = 1;
		foreach ($meals->childNodes as $elem)
		{
			$i++;
			if ($i % 2) continue;

			$logger->addMeal(trim($elem->nodeValue));
		}

		return TRUE;
	}
}
