<?php

/**
 * Lebo bez masa nie je den dnom. Maso je sucast jedla, preto chodim jest do
 * blizkych malych restauracii.
 */

$sites  = [
        'Pulitzer'      => 'http://pulitzer.sk/',
        'Twenties'      => 'http://www.twenties.sk/'
];

$xpaths = [
        'Pulitzer'      => [
                'Polievky'                      =>      '//*[@id="soups"]',
                'Hlavne zradla'         =>      '//*[@id="meals"]'
        ],
        'Twenties'      => [
                'Polievka + hlavne zradla'      => '//*[@id="article"]/div[2]/p[1]'
        ]
];

$output_file = '/tmp/results.php';
file_put_contents($output_file, '');

$dom = new DOMDocument();

foreach ($sites as $restaurant => $site)
{
        @$dom->loadHTML(file_get_contents($site));
        $xpath_obj = new DOMXPath($dom);

        append_result('V tovarni na jedlo s nazvom *' . $restaurant . "* maju dneska toto: \n");

        foreach ($xpaths[$restaurant] as $human_meal => $xpath)
        {
                append_result("\t$human_meal:\n");

                $oh_my_god_here_are_saved_meals = $xpath_obj->query($xpath);
                if ($oh_my_god_here_are_saved_meals === FALSE
                        OR $oh_my_god_here_are_saved_meals->length === 0)
                {
                        continue;
                }

                $found_meal = FALSE;
		foreach ($oh_my_god_here_are_saved_meals->item(0)->childNodes as $elem)
                {
                        $meal_meal_meal = trim($elem->nodeValue);
                        if (! empty($meal_meal_meal))
                        {
                                append_result("\t\t$meal_meal_meal\n");
                                $found_meal = TRUE;
                        }
                }

                if (! $found_meal)
                {
                        append_result("\tNevaria!!! Daj mi niekto gulomet, nech ich zabijem!\n");
                }
                else 
                {
                        append_result("\n");
                }
        }
}

append_result("\n\nMake me better on http://git.cinan.sk/obedparser.git/ :) \n");

function append_result($text)
{
        global $output_file;
        file_put_contents($output_file, $text, FILE_APPEND | FILE_TEXT);
}
