<?php
/**
 * Created by IntelliJ IDEA.
 * User: nosko
 * Date: 1/26/13
 * Time: 10:52 PM
 * To change this template use File | Settings | File Templates.
 */

/**
 * Class representing restaurant
 */
abstract class Restaurant {

    protected $url;
	protected $name;
	protected $xpaths = array();

	function __construct($name, $url, $xpaths) {

		if (empty($url) || empty($xpaths)) {
			throw new InvalidArgumentException("All argument are required");
		}

		$this->name = $name;
		$this->url = $url;

		if (is_string($xpaths)) {
			$this->xpaths[] = $xpaths;
		} else if (is_array($xpaths)) {
			$this->xpaths = $xpaths;
		} else {
			throw new InvalidArgumentException("Xpaths must be string or array");
		}
	}

    public function getName() {
        return $this->name;
    }

    public function getUrl() {
        return $this->url;
    }

    public function getXpaths() {
        return $this->xpaths;
    }

	public function runCallbackParser($parentNode, iOutput $logger) {
		return FALSE;
	}
}
