<?php

require_once "Restaurant.php";
require_once "Output.php";
require_once "Parser.php";

require_once "restaurants/Pulitzer.php";
require_once "restaurants/Twenties.php";

define('CONFIG_FILE', 'config.ini');

$data = parse_ini_file(CONFIG_FILE);
$outputType = ucfirst($data['output']);
$outputClass = sprintf('%sOutput', $outputType);

require_once sprintf("outputs/%s.php", $outputClass);
$output = new $outputClass();

$restaurants[] = new Pulitzer();
$restaurants[] = new Twenties();

#todo http://www.irish-pub.sk/sk/denne-menu
#todo http://www.mexicana.sk/dennemenu_sk.htm

$parser = new Parser($output, $restaurants);
$parser->parse();

$output->display();
