<?php
/**
 * Created by IntelliJ IDEA.
 * User: nosko
 * Date: 1/26/13
 * Time: 10:57 PM
 * To change this template use File | Settings | File Templates.
 */
class Parser {

    private $restaurants = array();
    private $logger;

    function __construct(iOutput $logger, $restaurants) {
        $this->logger = $logger;

        if (empty($restaurants) || !is_array($restaurants)) {
            throw new InvalidArgumentException("Array argument required");
        }

        $this->restaurants = $restaurants;
    }

    public function parse() {
        foreach ($this->restaurants as $restaurant) {
	        /** @var $restaurant Restaurant */

            $source = file_get_contents($restaurant->getUrl());

            if ($source === false) {
	            continue;
            }

            $dom = new DOMDocument();
            @$dom->loadHTML($source);
            $xpath_obj = new DOMXPath($dom);

	        $this->logger->addHeader($restaurant);

            foreach ($restaurant->getXpaths() as $name => $xpath) {

                $found = $xpath_obj->query($xpath);

                if ($found === false || $found->length === 0) {
                    continue;
                }

                $this->logger->addMealHeader($name);
                $this->logger->startListing();

                $parsed = $restaurant->runCallbackParser($found, $this->logger);

	            if ($parsed === false)
	            {
	                $exists = false;
	                foreach ($found->item(0)->childNodes as $elem) {

	                    $meal = trim($elem->nodeValue);
	                    if (!empty($meal)) {
		                    $this->logger->addMeal($meal);
	                        $exists = true;
	                    }
	                }
	            }

	            $this->logger->endListing();

                if ($parsed === '' OR (isset($exists) AND !$exists)) {
	                $this->logger->emptyRestaurant();
                }
            }
        }
    }
}
