<?php

require_once "Restaurant.php";
require_once "Output.php";
require_once "Parser.php";


class HtmlOutput extends Output  {

    public function display(){
        echo $this->output;
    }
}

class EmailOutput extends Output {

    private $outputFile = '/tmp/results.php';

    function __construct() {
        file_put_contents($this->outputFile, '');
    }

    public function log($message) {
        file_put_contents($this->outputFile, $message, FILE_APPEND | FILE_TEXT);
    }

    public function display(){
        // Send mail
    }
}

$twenties = new Restaurant("Twenties", "http://www.twenties.sk/", array("Polievky" => '//*[@id="article"]/div[2]/p[1]'));
$pulitzer = new Restaurant("Pulitzer", "http://www.pulitzer.sk",
    array("Polievky" => '//*[@id="soups"]',
        "Hlavne jedla" => '//*[@id="meals"]'));
$slovak = new Restaurant("Slovak pub", "http://www.arcaderestaurant.sk/articles/public_menu/show-modules/id/24",
    array("Salat" => '//*[@id="table2"]/tbody/tr[10]',
        "Polievka" => '//*[@id="table2"]/tbody/tr[2]'));


$htmlOutput = new HtmlOutput();
$emailOutput= new EmailOutput();
$parser     = new Parser($htmlOutput, array($twenties, $pulitzer, $slovak));
$parser->parse();
$htmlOutput->display();