<?php

require_once "Restaurant.php";
require_once "Output.php";
require_once "Parser.php";

define('CONFIG_FILE', 'config.ini');

$twenties = new Restaurant("Twenties", "http://www.twenties.sk/", array("Polievky" => '//*[@id="article"]/div[2]/p[1]'));
$pulitzer = new Restaurant("Pulitzer", "http://www.pulitzer.sk",
    array("Polievky" => '//*[@id="soups"]',
        "Hlavne jedla" => '//*[@id="meals"]'));
$slovak = new Restaurant("Slovak pub", "http://www.arcaderestaurant.sk/articles/public_menu/show-modules/id/24",
    array("Salat" => '//*[@id="table2"]/tbody/tr[10]',
        "Polievka" => '//*[@id="table2"]/tbody/tr[2]'));


$data = parse_ini_file(CONFIG_FILE);
$outputType = ucfirst($data['output']);
$outputClass = sprintf('%sOutput', $outputType);

require_once sprintf("outputs/%s.php", $outputClass);
$output = new $outputClass();

$parser     = new Parser($output, array($twenties, $pulitzer, $slovak));
$parser->parse();
$output->display();