<?php

require_once "Restaurant.php";
require_once "Output.php";
require_once "Parser.php";

define('CONFIG_FILE', 'config.ini');

$twenties = new Restaurant("Twenties", "http://www.twenties.sk/", ["Polievka aj zradlo" => '//*[@id="article"]/div[2]/p[1]']);
$pulitzer = new Restaurant("Pulitzer", "http://www.pulitzer.sk",  ["Tekute predjedlo" => '//*[@id="soups"]', "Zradlo" => '//*[@id="meals"]']);
#todo http://www.irish-pub.sk/sk/denne-menu
#todo http://www.mexicana.sk/dennemenu_sk.htm

$data = parse_ini_file(CONFIG_FILE);
$outputType = ucfirst($data['output']);
$outputClass = sprintf('%sOutput', $outputType);

require_once sprintf("outputs/%s.php", $outputClass);
$output = new $outputClass();

$parser     = new Parser($output, array($twenties, $pulitzer));
$parser->parse();
$output->display();