<?php
/**
 * Created by IntelliJ IDEA.
 * User: nosko
 * Date: 1/26/13
 * Time: 10:57 PM
 * To change this template use File | Settings | File Templates.
 */
class Parser {

    private $restaurants = array();
    private $logger;

    function __construct(iOutput $logger, $restaurants) {
        $this->logger = $logger;

        if (empty($restaurants) || !is_array($restaurants)) {
            throw new InvalidArgumentException("Array argument required");
        }

        $this->restaurants = $restaurants;
    }

    public function parse() {
        foreach ($this->restaurants as $restaurant) {

            $source = file_get_contents($restaurant->getUrl());

            if ($source === false) {
                throw new RuntimeException("Can't read source address: " . $restaurant->getUrl());
            }

            $dom = new DOMDocument();
            @$dom->loadHTML($source);
            $xpath_obj = new DOMXPath($dom);

            $this->logger->log("Restaurant: <a href='{$restaurant->getUrl()}'>" . $restaurant->getName() . "</a>".$this->logger->newLine());

            foreach ($restaurant->getXpaths() as $name => $xpath) {

                $found = $xpath_obj->query($xpath);

                if ($found === false || $found->length === 0) {
                    continue;
                }

                $this->logger->log("<b>$name</b>");
                $this->logger->log("<ul>");
                $exists = false;
                foreach ($found->item(0)->childNodes as $elem) {

                    $meal = trim($elem->nodeValue);
                    if (!empty($meal)) {
                        $this->logger->log("\t<li>$meal</li>\n");
                        $exists = true;
                    }
                }
                $this->logger->log("</ul>");

                if (!$exists) {
                    $this->logger->log("<i>Hovno. Nic nemaju.</i>" . $this->logger->newLine());
                }
            }

            $this->logger->log($this->logger->newLine());
        }
    }
}
