<!DOCTYPE html>
<html lang="sk">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="Curriculum Vitae - Frantisek Elias">
	<meta name="keywords" content="Frantisek, Elias, cv, zivotopis, curriculum vitae, bratislava, programator, php, dart, student, developer, webdeveloper">
	<meta name="author" content="František Eliáš">
	<title>František Eliáš - Curriculum Vitae</title>
	
	<link href="/assets/css/bootstrap.css" rel="stylesheet">
	<link href="/assets/css/bootstrap-responsive.css" rel="stylesheet">

	<!--[if lt IE 9]>
	  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

	<!-- Piwik -->
	<script type="text/javascript">
	  var _paq = _paq || [];
	  _paq.push(["trackPageView"]);
	  _paq.push(["enableLinkTracking"]);

	  (function() {
	    var u=(("https:" == document.location.protocol) ? "https" : "http") + "://stats.cinan.sk/";
	    _paq.push(["setTrackerUrl", u+"piwik.php"]);
	    _paq.push(["setSiteId", "3"]);
	    var d=document, g=d.createElement("script"), s=d.getElementsByTagName("script")[0]; g.type="text/javascript";
	    g.defer=true; g.async=true; g.src=u+"piwik.js"; s.parentNode.insertBefore(g,s);
	  })();
	</script>
	<!-- End Piwik Code -->
</head>
<body class="preview" data-spy="scroll" data-target=".subnav" data-offset="80">
	<div class="container" itemscope itemtype="http://schema.org/Person">
		<header class="jumbotron">
			<div class="row">
				<div class="span12">
					<hgroup>
						<h1 style="padding: 10px 0; text-align: center; font-size: 60px" itemprop="name">František Eliáš</h1>
						<h2 style="text-align: center">curriculum vitae</h2>
					</hgroup>
					<address style="text-align: center"><br />
						<a href="http://blog.cinan.sk" target="_blank" itemprop="url">Blog</a><br />
						<a href="http://sk.linkedin.com/in/frantisekelias" itemprop="url" rel="me">LinkedIn</a><br /><br />
						<a href="mailto:elias.frantisek@gmail.com" itemprop="email">elias.frantisek@gmail.com</a><br />
						<a href="tel:+421949376613" itemprop="telephone">+421 949 376 613</a>
					</address>
				</div>
			</div> 
		</header>

		<section id="about">
			<div class="row">
				<div class="page-header">
					<h2>O mne</h2>
				</div>
			</div> 
			<div class="row" itemprop="description">
				<div class="span12">Pred <?= floor((time() - mktime(0,0,0, 7, 29, 1992)) / (60 * 60 * 24 * 365)) ?> rokmi som sa narodil Bardejove. Teraz žijem v Bratislave a študujem na Matfyze. Som v 5. ročníku odboru Aplikovaná informatika.
				<br>Rád programujem webové služby a aplikácie. Zvyčajne vyvíjam na platforme Linux/BSD + Apache/Nginx + Mysql + PHP, ale mám skúsenosti aj Dartom, RoR aplikáciami a NoSQL databázami. 
				<br>Tiež sa hrám s Linuxovými a FreeBSD servermi.
				<br>
				<br>Uznávam Lego. Neuznávam dotykové telefóny bez hardwarovej klávesnice.
				<br>Na internet nechodím, ja tu žijem.
				</div>
			</div>
		</section>

		<section id="education">
			<div class="row">
				<div class="page-header">
					<h2>Vzdelanie</h2>
				</div>
			</div>
			
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>Fakulta matematiky, fyziky a informatiky, Univerzita Komenského, Bratislava</h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2013 &ndash; súčasnosť</span>
						<span class="hidden-phone pull-right description">2013 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Aplikovaná informatika, magisterský stupeň (zameranie počítačová grafika)</div>
				</div>
			</section>
			<br>
			<section itemprop="alumniOf" itemscope itemtype="http://schema.org/CollegeOrUniversity">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4 itemprop="name">Fakulta matematiky, fyziky a informatiky, Univerzita Komenského, Bratislava</h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2010 &ndash; 2013</span>
						<span class="hidden-phone pull-right description">2010 &ndash; 2013</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Aplikovaná informatika, bakalársky stupeň</div>
				</div>
			</section>
			<br>
			<section itemprop="alumniOf" itemscope itemtype="http://schema.org/HighSchool">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4 itemprop="name">Osemročné gymnázium sv. Jána Bosca, Bardejov</h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2002 &ndash; 2010</span>
						<span class="hidden-phone pull-right description">2002 &ndash; 2010</span>
					</div>
				</div>
			</section>
		</section>

		<section id="courses">
			<div class="row">
				<div class="page-header">
					<h2>Kurzy a školenia</h2>
				</div>
			</div>
			
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>10gen Education <a href="https://education.10gen.com/" target="_BLANK"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Október 2012 &ndash; December 2012</span>
						<span class="hidden-phone pull-right description">Október 2012 &ndash; December 2012</span>
					</div>
				</div>
				
				<div class="row">
					<div class="span6 description">MongoDB for Developers</div>
				</div>
			</section>
				
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>Inštitút cudzích jazykov, Bardejov <a href="http://icj-bardejov.sk/" target="_BLANK"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2006 &ndash; 2010</span>
						<span class="hidden-phone pull-right description">2006 &ndash; 2010</span>
					</div>
				</div>
				
				<div class="row">
					<div class="span6 description">Kurz anglického jazyka</div>
				</div>
			</section>
		</section>

		<section id="experience">
			<div class="row">
				<div class="page-header">
					<h2>Zamestnania</h2>
				</div>
			</div>
			
			<section id="staffino" itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">Staffino</span> <a href="http://staffino.com/" target="_BLANK" itemprop="url"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Júl 2014 &ndash; súčasnosť</span>
						<span class="hidden-phone pull-right description">Júl 2014 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Programátor</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Venovanie sa jedinému projektu &ndash; Staffino</li>
							<li>Návrh a programovanie single-page aplikácie</li>
							<li>Používané technológie: Dart, Angular.dart, IndexedDB, Grunt.js, Git</li>
						</ul>
					</div>
				</div>
			</section>

			<section id="backbone" itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">Backbone s.r.o.</span> <a href="http://backbone.sk" target="_BLANK" itemprop="url"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Júl 2012 &ndash; súčasnosť</span>
						<span class="hidden-phone pull-right description">Júl 2012 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Programátor</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Programovanie stránok na zakázku</li>
							<li>Používané technológie: PHP, firemný MVC framework v PHP, Javascript/Coffeescript, MySQL, Twig, SCSS, Capistrano, Svn, Git</li>
							<li>Práca v tíme</li>
						</ul>
					</div>
				</div>
			</section>

			<section itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">212 s.r.o.</span> <a href="http://212.sk" target="_BLANK" itemprop="url"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Február 2012 &ndash; Apríl 2013</span>
						<span class="hidden-phone pull-right description">Február 2012 &ndash; Apríl 2013</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Webmaster</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Úprava webstránok podľa pokynov zadávateľa</li>
							<li>Spravovanie stránok bežiacich na Drupale</li>
							<li>Samostatná práca</li>
						</ul>
					</div>
				</div>
			</section>
		</section>
	      
		<section id="technical">
			<div class="row">
				<div class="page-header">
					<h2>Jazyky</h2>
				</div>
			</div>
			<div class="row" itemprop="description">
			  <h4><span itemprop="name"><em>Zoradené podľa obľúbenosti</em></span></h4>
			</div>
			<div class="row">
				<div class="span8">
					<?php
					iprogram('Dart','80');
					iprogram('PHP','90');
					iprogram('MySQL','85');
					iprogram('IndexedDB','60');
					iprogram('MongoDB','50');
					iprogram('Javascript/Coffeescript','65');
					iprogram('Java','35');
					iprogram('Ruby','40');
					iprogram('C++','30');
					iprogram('CSS','50');
					iprogram('Haskell','20');
					iprogram('R','15');
					iprogram('Matlab','15');
					?>
				</div>
				<div class="span4">
					<div class="well"> 
						<h4>Vlastné a školské projekty</h4>
						<hr />
						<ul>
						<?= project('Bakalárska práca &ndash; XMPP (Jabber) chat so simulovanými MUC', 'Ruby (on Rails), MongoDB, Websocket, Backbone.js, SCSS', '','http://git.cinan.sk/xmpp-bachelor.git/') ?>
						<?= project('Administrácia tohto servera', 'GNU/Linux, Nginx, PHP, MySQL, Git server, zálohovacie úložište, ownCloud, Octopress blog, Piwik') ?>
						<?= project('Socket.IO pre Dart', 'Portovanie Socket.IO do Dartu s využitím dartovských idiómov') ?>
						</ul>
						<a class="pull-right btn btn-small btn-inverse" href="http://git.cinan.sk">Môj Git <i class="icon-arrow-right icon-white"></i></a><br />
					</div>
				</div>
			</div>
		</section>      
		<section id="foreign-languages">
			<div class="row">
				<div class="page-header">
					<h2>Jazykové znalosti</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li><span title="Vyhral som 1. miesto v okresnom kole súťaže zo slovenskej gramatiky :)" style="border-bottom: 1px dotted #BBB">Slovenský jazyk</span> &ndash; materinský jazyk</li>
						<li>Anglický jazyk &ndash; aktívne</li>
						<li>Ruský jazyk &ndash; základy</li>
						<li>Francúzsky jazyk &ndash; základy</li>
					</ul>
				</div>
			</div>
		</section>
		<section id="driver-license">
			<div class="row">
				<div class="page-header">
					<h2>Vodičský preukaz</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li>Skupina B</li>
						<!--<li>A mozno tu pribude aj A skupina</li>-->
					</ul>
				</div>
			</div>
		</section>
		<footer>
			<small style="text-align: center; display: block;">František Eliáš, <?= date('Y') ?></small>
		</footer>
	</div>
</body>
</html>

<?php

function iprogram($language,$percent) {
	echo <<<EOD
<div class="row">
	<div class="span3">
		<h4 style="text-align: right" class="hidden-phone">$language</h4>
		<span class="badge visible-phone" style="text-align: center">$language</span>
	</div>
	<div class="span4">
		<div class="progress" style="margin: 10px 0 10px 0; height: 22px;">
			<div class="bar" style="width: $percent%;"></div>
		</div>
	</div>
</div>
EOD;
	
}

function project($name, $technologies, $look = '', $code = '') {
	echo '<li style="padding-top: 12px">';
	
	if (!empty($look)) {
		echo '<a href="'.$look.'" target="_BLANK">'.$name.'</a>';
		echo '<br><span><em>'.$technologies.'</em></span>';
	} else {
		echo $name;
		echo '<br><span><em>'.$technologies.'</em></span>';
	}
	
	if (!empty($code)) {
		echo ' <a href="'.$code.'" target="_BLANK"><span class="pull-right badge badge-info">Zdrojáky <i class="icon-arrow-right icon-white"></i></span></a>';
	}
	echo '</li>';
}
?>
