
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>Philip I. Thomas Curriculum Vitae</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Curriculum Vitae for Philip I. Thomas">
    <meta name="author" content="Philip I. Thomas">

    <!-- Le styles -->
    <link href="../assets/css/bootstrap.css" rel="stylesheet">
    <style>
      body {
        padding-top: 60px; /* 60px to make the container go all the way to the bottom of the topbar */
      }
    </style>
    <link href="../assets/css/bootstrap-responsive.css" rel="stylesheet">

    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->

    <!-- Le fav and touch icons -->
    <link rel="shortcut icon" href="../assets/ico/favicon.ico">
	<script type="text/javascript">

	  var _gaq = _gaq || [];
	  _gaq.push(['_setAccount', 'UA-9939917-3']);
	  _gaq.push(['_setDomainName', 'philipithomas.com']);
	  _gaq.push(['_trackPageview']);

	  (function() {
	    var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
	    ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
	    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
	  })();

	</script>
  
  </head>

<body class="preview" data-spy="scroll" data-target=".subnav" data-offset="80">
<!--
    <div class="navbar navbar-fixed-top">
      <div class="navbar-inner">
        <div class="container">
          <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
            </a>
          <a class="brand" href="#">Curriculum Vitae</a>
          <div class="nav-collapse collapse">
            <ul class="nav">
              <li><a href="#about">About</a></li>
              <li><a href="#education">Education</a></li>
              <li><a href="#experience">Experience</a></li>
              <li><a href="#technical">Technical</a></li>
              <li><a href="#honors">Honors</a></li>
              
            </ul>
            <div class="nav-collapse collapse pull-right">
            <ul class="nav">
              <li><a href="http://philipithomas.com" target="_blank>">Homepage</a></li>
              <li class="dropdown ">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                            Links <i class="caret"></i>
                            </a>

                   <ul class="dropdown-menu ">
                                <li><a href="http://linkedin.com/in/philiptihomas" target="_blank">LinkedIn</a></li>
                <li><a href="http://github.com/philipithomas" target="_blank">Github</a></li>
                <li><a href="http://twitter.com/philipithomas" target="_blank"><i class="icon-off"></i> Sign Out</a></li>
            </ul>
               </li>
              <li><a href="/resume.pdf">Download PDF</a></li>          
            </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
-->
    <div class="container">
	
	<header class="jumbotron">
		
    <div class="row">
	<div class="span12">
		<h3 style="text-align: center; text-style: italic">Curriculum Vitae for</h3>
		
      <h1 style="padding: 10px 0px; text-align: center; font-size: 60px">Philip I. Thomas</h1>
	<span class="" style="text-align: center;"> 
		<address>
		<a href="http://philipithomas.com" target="_blank">www.philipithomas.com</a><br />
		<a href="mailto:#">mail@philipithomas.com</a><br />
		<a>+1.209.867.7445</a>
		</address>
	</span>
		</div>
    </div> 

	</header>

<section id="about">
      <div class="row">

      <div class="page-header">
 <h2>About</h2>
      </div>
          </div> 
          <div class="row">
      
      <div class="span12">Philip I. Thomas is a senior at Washington University majoring in systems engineering and physics. He also works for Cultivation Capital as an analyst and is a founder of two startups — the Food Trucks Near Me website and Automation Kit, a company focused on helping companies automate their digital marketing. He intends to work in data analysis after graduation, and is currently seeking employment opportunities. </div>
    </div> 

      </section>

      <section id="education">
            <div class="row">

      <div class="page-header">
      <h2>Education</h2>
      </div>
    </div> <!-- end row -->
<?php
position("Washington University in Saint Louis","Saint Louis, MO","Bachelor of Science in Systems Engineering and Physics","Expected 5/13",'
<ul>
<li><span style="font-weight: bold">Honors:</span> J. Alan and Marcia K. Ritter Scholar.</li>
<li><span style="font-weight: bold">Relevant Coursework:</span> Operations Research, Stochastic Models, Signals Analysis.</li>
<li><span style="font-weight: bold">Senior Project:</span> Analysis of <a href="http://aisle411.com/" target="_BLANK">Aisle411</a> Usage Data <span style="font-style:italic">(In Progress)</span></li>
</ul>',"");
position("Case Western Reserve University","Cleveland, OH","Organic chemistry lecture and laboratory","6/10-8/10","","");

?>

      </section>
      
      
      
      <section id="experience">
            <div class="row">

      <div class="page-header">
      <h2>Professional and Leadership Experience </h2>
      </div>
    </div> <!-- end row -->
    <?php


	position("Automation Kit","Saint Louis, MO","Managing Partner","6/12-Present",'
	<ul>
	<li>Equipped over a dozen clients with marketing tools to capture, convert, and cultivate leads automatically.</li>
	<li><span style="font-weight: bold">Selected Clients:</span> Hostirian, Systematic Revenue, Venture Draft, St. Louis Arch Angels.</li>
	</ul>','http://automationkit.com');
	
	
	position("Food Trucks Near Me","Saint Louis, MO","Founder","6/12-Present",'
	<ul>
	<li>Developed, launched, and marketed food truck finder website with successful launches in five cities, resulting in extensive media coverage and sustained web traffic.</li>
	<li>Designed cross-platform CRM system to infer user cities of interest based on interactions with email updates and website, resulting in increased advertising relevancy for users.</li>
	<li>Implemented automated cross-platform social media system resulting in high return traffic.</li>
	</ul>',"http://foodtrucksnearme.com");
	
	
	position("Cultivation Capital","Saint Louis, MO","Analyst","3/12-Present",'
	<up
	<li>Performed screening of potential investments with a focus on technical analysis of technology and operations for due diligence reporting. </li>
	</ul>',"http://cultivationcapital.com");
	
	
	position("Washington University Tech Entrepreneurs (wute)","Saint Louis, MO","Director - wute.vc","9/11-Present",'
	<ul>
	<li>Launched wute.vc, a lecture series connecting students with venture capitalists and seasoned entrepreneurs, resulting in sponsorship by <a href="http://cultivationcaptital.com" target="_BLANK">Cultivation Capital</a>.</li>
	<li>Attracted over 200 students to <a href="http://wute.vc/2012/10/press-release-alexis-ohanian-kicks-off-student-run-venture-capital-lecture-series-at-wustl/">first wute.vc speech by Reddit Co-Founder Alexis Ohanian</a> using a paperless marketing campaign.</li>
	<li>Designed <a href="http://wute.vc" target="_BLANK">wute.vc</a> and re-designed <a href="http://wute.org" target="_BLANK">wute.org</a> websites.</li>
	</ul>', "http://wute.org");
	
	
	position("Washington University in St. Louis Department of Physics","Saint Louis, MO","Teaching Assistant, General Physics I and General Physics II","8/11-Present","", "");
	
	
	position("WUSauce","St. Louis, MO","Communication Chair","9/10-Present",'
	<ul>
	<li>Performed with audition-only salsa dance team, taught salsa lessons, and participated in community outreach.</li>
	<li>Implemented improved website and email marketing system, resulting in 20% increase in annual audition attendance and 200% increase in weekly lesson retention throughout each semester.</li>
	<li>Served as Communication Director for annual Dance-Off event in 2011 and 2012, resulting in over 500 students attending each event.</li>
	</ul>',"http://wusauce.wustl.edu");
	
	
	position("Sapientia Media","St. Louis, MO","President","5/10-Present",'
	<ul>
	<li>Spearheaded client relation management, digital marketing strategy, website design, and brand positioning services.</li>
	<li><span style="font-style:italic;">Selected Clients:</span> Evetos, On The Edge, St. Albans Promotions.</li>
	</ul>',"http://sapientiamedia.com");
	
	
	position("Washington University Student Investment Fund","St. Louis, MO","Communication Chair","1/10-6/12",'
	<ul>
	<li>Managed the investment of over $100,000 of the university endowment via qualitative, multiples, and DCF analysis, resulting in  growth exceeding S&P 500 Midcap Index on invested funds.</li>
	<li>Competed nationally in investment competitions, and was a Finalist in the Spring 2011 <a href="http://miiuic.org/" target="_BLANK">Michigan Interactive Investments Competition</a>.</li>
	<li><span style="font-style:italic;">Previous Positions:</span> Technology Portfolio Manager (2010), Webmaster (2010-2011), Healthcare Analyst (2010).</li>
	</ul>',"http://wusif.org");
	
	
	position("Washington University in St. Louis Department of Computer Science","St. Louis, MO","Teaching Assistant, Introduction to Computing Tools: MATLAB","1/11-6/11","","");
	
	
   	position("Washington University School of Medicine in St. Louis","St. Louis, MO","Research Assistant, Dr. Jennifer Lodge Laboratory","9/09-1/12",'
	<ul>
	<li>Studied pathogenic fungus <a href="http://en.wikipedia.org/wiki/Cryptococcus_neoformans" target="_BLANK"><span style="font-style:italic;">Cryptococcus neoformans</span></a> with in vitro, in vivo, and computational techniques.</li>
	<li>Selected Project Experience:
		<ul>
			<li>Bioinformatics – Designed, developed, and implemented a scalable <span style="font-style:italic;">C. neoformans</span> Strain Database for collaborative use in the scientific community. </li>
			<li>Gene research – Studied stress sensors involved with nitrositive stress.</li>
			<li>Animal testing – Analyzed strain virulence with <span style="font-style"italic;">in vitro</span> studies in mice.</li>
		<ul>

			
	</li>
	</ul>',"");


           ?>
    
    
      </section>
      
      <section id="technical">
            <div class="row">

      <div class="page-header">
      <h2>Technical</h2>
      </div>
    </div> <!-- end row -->
<div class="row">

	
	<div class="span8">
<?php
iprogram('Matlab','90');
iprogram('PHP','85');
iprogram('Java','55');
iprogram('CSS','40');
iprogram('Python','45');
iprogram('Relational Databases','85');
iprogram('NoSQL Databases','55'); 
iprogram('Javascript','20');
iprogram('Adobe CS6','40');
iprogram('Git','70');
iprogram('Unix System Administration','40');
iprogram('Mathematica','60');



?>
</div>
<div class="span4">
	<div class="well">
		<h4>Selected Projects</h4>
		<hr />
		<ul>
		<?php
			project('Food Trucks Near Me','http://www.foodtrucksnearme.com','');
			project('Computational Analysis of Diffusion as a Stochastic System','','http://github.com/philipithomas/diffusion');
			project('CSE131 Java','','https://github.com/philipithomas/cse131Java');
			project('Curriculum Vitae','','https://github.com/philipithomas/cv-philipithomas');
			project('Kill The Landline','http://killthelandline.com','');
		?>
		</ul>
		<a class="pull-right btn btn-small btn-inverse" href="http://github.com/philipithomas">Github Profile <i class="icon-arrow-right icon-white"></i></a><br />
	</div>
</div>
</div>
      
      </section>
      
      
      <section id="honors">
            <div class="row">

      <div class="page-header">
      <h2>Honors and Skills</h2>
      </div>
    </div> <!-- end row -->
	<div class="row">
	<div class="span8">
	<?php
	
	extra('Awards','Eagle Scout<br />Honorable Mention at 2012 Startup Weekend Columbia (<a href="http://killthelandline.com" target="_BLANK">Kill the Landline</a>)<br />Finalist in Spring
	2011 Michigan Interactive Investments Competition');
	extra('Language','Conversational Proficiency in Spanish');
	extra('Organizations','The Engineer\'s Club of St. Louis');
	extra('Interests','Salsa Dancing<br /><a href="http://beer.philipithomas.com" target="_BLANK">Craft Beer</a><br />Coffee<br />Rock Climbing');
	
	?>
	</div>
	<div class="span4">
	<div class="well">
		<h4>Selected Press</h4>
		<hr />
		<ul>
			<li>St. Louis Business Journal: <a href="http://www.bizjournals.com/stlouis/blog/BizNext/2012/10/community-voices-philip-thomas-at.html?page=all">Philip Thomas at Startup Weekend </a></li>
				<li>Fox 2 Now: <a href="http://philipithomas.com/2012/07/food-truck-stl-on-fox-2-news-in-the-morning/">Live Interview with Food Truck Site Founder Philip I. Thomas </a></li>
				<li>Forbes: <a href="http://www.forbes.com/sites/kaipetainen/2011/11/11/washu-students-provide-teva-some-healthy-love/">WashU Students Provide Teva Some Healthy Love</a></li>
			<li>St. Louis Business Journal: <a href="http://www.bizjournals.com/stlouis/blog/BizNext/2012/09/wutevc-starts-venture-capital-lecture.html">wute.vc starts venture capital lecture series</li>
		</ul>
		<a class="pull-right btn btn-small btn-inverse" href="http://philipithomas.com/press">View Full Press <i class="icon-arrow-right icon-white"></I></a><br />
	</div>
	</div>
	</div>


      </section>

      <footer style="padding-top: 20px;">
	<hr />
      <p style="text-align: center">&copy; <a href="#">Philip I Thomas</a> 2012</p>
      </footer>      

    </div> <!-- /container -->

    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="../assets/js/bootstrap.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>

  </body>
</html>

<?php
// =========================================================
/* 

These are some functions to make uniform sections

*/

function position($company,$city,$job,$dates,$blob,$link) {
	/*
	This function is for use in the experience section. It unififes formatting for the various positions. 
	*/
	
	echo '
		<div class="row" style="padding: 35px 0 4px 0;">
			<div class="span8"><h4 style="margin: 0">'.$company;
				if (!empty($link)) {
					echo ' <a href="'.$link.'" target="_BLANK"><span class="badge">Website <i class="icon-arrow-right icon-white"></i></span></a>';
				}
			echo '</h4> 
			
			</div>	
			<div class="span4"><h4 class="pull-right hidden-phone" style="margin: 0">'.$city.'</h4>
			</div>
			
		</div> <!-- end row-->
			
		<div class="row">
			<div class="span6"><span style="font-style:italic; font-size: 15px;">'.$job.'</span></div>	
			<div class="span6">
			<span class="visible-phone label">'.$dates.'</span>
			<span class="hidden-phone pull-right" style="font-style:italic; font-size: 15px;" >'.$dates.'</span>
			
			</div>
		</div> <!-- end row-->
		';
		if (!empty($blob)) {
			echo '
			<div class="row" style="padding-top: 8px;"><div class="span12">'.$blob.'</div></div>';
			}	
			
}


function iprogram($language,$percent) {
	// Progress bars for technical section
	echo '
	<div class="row">
		<div class="span3"
		<p><h4 style="text-align: right" class="hidden-phone">'.$language.'</h4></p>
		<p><span class="badge visible-phone" style="text-align: center">'.$language.'</span></p>
		</div>
		<div class="span4">
	      <div class="progress" style="margin: 10px 0 10px 0; height: 22px;">
	        <div class="bar" style="width: '.$percent.'%;"></div>
	      </div>
	    </div>
		<div class="span1"></div>
	</div>
	';
	
}

function project($name,$look,$code) {
	// Makes lists for displaying projects
	echo '<li style="padding-top: 12px">'.$name;
	if (!empty($look)) {
		// link to look at completed project
		echo ' <a href="'.$look.'" target="_BLANK" ><span class="badge badge-success">Visit <i class="icon-arrow-right icon-white"></i></label></a>';
	}
	if (!empty($code)) {
		// link to look at completed project
		echo ' <a href="'.$code.'" target="_BLANK""><span class="badge badge-info">Code <i class="icon-arrow-right icon-white"></i></span></a>';
	}
	echo '</li>';
}

function extra($title,$blob) {
	echo '<div class="row" style="padding-top:30px">
				<div class="span3">
					<span class="pull-right hidden-phone"><strong>'.$title.'</strong></span>
					<span class="visible-phone badge">'.$title.'</span>
				</div>
				<div class="span5">
					'.$blob.'
				</div>
			</div>';
				
}
?>