<!DOCTYPE html>
<html lang="sk">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="Curriculum Vitae - Frantisek Elias">
	<meta name="author" content="Frantisek Elias">
	<title>František Eliáš - Curriculum Vitae</title>
	
	<link href="/assets/css/bootstrap.css" rel="stylesheet">
	<link href="/assets/css/bootstrap-responsive.css" rel="stylesheet">

	<!--[if lt IE 9]>
	  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
</head>
<body class="preview" data-spy="scroll" data-target=".subnav" data-offset="80">
	<div class="container">
		<header class="jumbotron">
			<div class="row">
				<div class="span12">
					<hgroup>
						<h1 style="padding: 10px 0px; text-align: center; font-size: 60px">František Eliáš</h1>
						<h2 style="text-align: center; text-style: italic">curriculum vitae</h2>
					</hgroup>
					<address style="text-align: center">
						<a href="http://cinan.sk" target="_blank">www.cinan.sk</a><br />
						<a href="mailto:elias.frantisek@gmail.com">elias.frantisek@gmail.com</a><br />
						<a href="tel:+421949376613">+421 949 376 613</a>
					</address>
				</div>
			</div> 
		</header>

		<section id="about">
			<div class="row">
				<div class="page-header">
					<h2>O mne</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">Študujem na Fakulte fyziky, matematiky a informatiky na Univerzite Komenského. Som v 3. ročníku odboru Aplikovaná informatika. Rád programujem moderné webové stránky a aplikácie. Zvyčajne vyvíjam na platforme Linux + Apache + Mysql + PHP, ale mám skúsenosti aj so svetom Ruby On Rails. 
				<br />Na internet nechodím, ja tu žijem.</div>
			</div>
		</section>

		<section id="education">
			<div class="row">
				<div class="page-header">
					<h2>Vzdelanie</h2>
				</div>
			</div>
			<? 
			position("Fakulta matematiky, fyziky a informatiky, Univerzita Komenského, Bratislava","Aplikovaná informatika","2010 - súčasnosť",'',"");
			echo '<br />';
			position("Osemročné gymnázium sv. Jána Bosca, Bardejov","","2002 - 2010",'',"");
			?>
		</section>
		
		<section id="experience">
			<div class="row">
				<div class="page-header">
					<h2>Zamestnania</h2>
				</div>
			</div>
		<?
			position("Backbone s.r.o.","Programátor","Júl 2012 - súčasnosť",'<ul>
				<li>Programovanie stránok na zakázku</li>
					<li>PHP (firemný MVC framework), Javascript, MySQL, templatovací systém Twig, SCSS</li>
				<li>Práca v tíme</li></ul>', 'http://backbone.sk'
			);
			
			position("212 s.r.o.","Správa webstránok","Február 2012 - súčasnosť",'<ul>
				<li>Úprava webstránok podľa pokynov zadávateľa</li>
				<li>Spravovanie stránok bežiacich na Drupale</li>
				<li>Samostatná práca</li></ul>', 'http://212.sk'
			);
		?>
		</section>
	      
		<section id="technical">
			<div class="row">
				<div class="page-header">
					<h2>Vedomosti</h2>
				</div>
			</div>
			<div class="row">
				<div class="span8">
					<?
					iprogram('PHP','85');
					iprogram('Java','55');
					iprogram('CSS','40');
					iprogram('Ruby','45');
					iprogram('MySQL','85');
					iprogram('MongoDB','55'); 
					iprogram('Javascript','20');
					iprogram('Git','70');
					iprogram('C++','70');
					iprogram('Haskell','70');
					iprogram('Bash','70');
					iprogram('Linux a tak','40');
					?>
				</div>
				<div class="span4">
					<div class="well">
						<h4>Vlastné a školské projekty</h4>
						<hr />
						<ul>
						<?php
						project('Food Trucks Near Me','http://www.foodtrucksnearme.com','');
						project('Computational Analysis of Diffusion as a Stochastic System','','http://github.com/philipithomas/diffusion');
						project('CSE131 Java','','https://github.com/philipithomas/cse131Java');
						project('Curriculum Vitae','','https://github.com/philipithomas/cv-philipithomas');
						project('Kill The Landline','http://killthelandline.com','');
						?>
						</ul>
						<a class="pull-right btn btn-small btn-inverse" href="http://github.com/philipithomas">Môj git <i class="icon-arrow-right icon-white"></i></a><br />
					</div>
				</div>
			</div>
		</section>      
		<section id="foreign-languages">
			<div class="row">
				<div class="page-header">
					<h2>Jazykové znalosti</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li><span title="Vyhral som 1. miesto v okresnom kole súťaže zo slovenskej gramatiky" style="border-bottom: 1px dotted #BBB">Slovenský jazyk</span> &ndash; materinský jazyk</li>
						<li>Anglický jazyk &ndash; aktívne</li>
						<li>Ruský jazyk &ndash; základy</li>
						<li>Francúzsky jazyk &ndash; základy</li>
					</ul>
				</div>
			</div>
		</section>
		<section id="driver-license">
			<div class="row">
				<div class="page-header">
					<h2>Vodičský preukaz</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li>Skupina B</li>
					</ul>
				</div>
			</div>
		</section>
		<footer>
			<small style="text-align: center; display: block;">František Eliáš, 2012</small>
		</footer>
	</div>
</body>
</html>

<?php
function position($company,$job,$dates,$blob,$link) {
	$linkhtml = empty($link)
		? ''
		: '<a href="'.$link.'" target="_BLANK"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a>';

	$blobhtml = empty($blob)
		? ''
		: '<div class="row" style="padding-top: 8px;"><div class="span12">'.$blob.'</div></div>';

	echo <<<EOD
<div class="row">
	<div class="span8">
		<hgroup>
			<h4>$company $linkhtml</h4>
		</hgroup>
	</div>
	<div class="span4">
		<span class="visible-phone label">$dates</span>
		<span class="hidden-phone pull-right" style="font-style:italic; font-size: 15px;" >$dates</span>
	</div>
</div>
<div class="row">
	<div class="span6"><span style="font-style:italic; font-size: 15px;">$job</span></div>
</div>
$blobhtml
EOD;

}


function iprogram($language,$percent) {
	echo <<<EOD
<div class="row">
	<div class="span3">
		<h4 style="text-align: right" class="hidden-phone">$language</h4>
		<span class="badge visible-phone" style="text-align: center">$language</span>
	</div>
	<div class="span4">
		<div class="progress" style="margin: 10px 0 10px 0; height: 22px;">
			<div class="bar" style="width: $percent%;"></div>
		</div>
	</div>
</div>
EOD;
	
}

function project($name,$look,$code) {
	echo '<li style="padding-top: 12px">';
	
	if (!empty($look)) {
		echo '<a href="'.$look.'" target="_BLANK">'.$name.'</a>';
	}
	else {
		echo $name;
	}
	
	if (!empty($code)) {
		echo ' <a href="'.$code.'" target="_BLANK"><span class="badge badge-info">Zdrojáky <i class="icon-arrow-right icon-white"></i></span></a>';
	}
	echo '</li>';
}
?>
