<!DOCTYPE html>
<html lang="sk">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="Curriculum Vitae - Frantisek Elias">
	<meta name="keywords" content="Frantisek, Elias, cv, zivotopis, curriculum vitae, bratislava, programator, php, dart, javascript, developer, webdeveloper, mobilne aplikacie">
	<meta name="author" content="František Eliáš">
	<title>František Eliáš - Curriculum Vitae</title>
	
	<link href="/assets/css/bootstrap.css" rel="stylesheet">
	<link href="/assets/css/bootstrap-responsive.css" rel="stylesheet">

	<!--[if lt IE 9]>
	  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->

	<!-- Piwik -->
	<script type="text/javascript">
	  var _paq = _paq || [];
	  _paq.push(["trackPageView"]);
	  _paq.push(["enableLinkTracking"]);

	  (function() {
	    var u=(("https:" == document.location.protocol) ? "https" : "http") + "://stats.cinan.sk/";
	    _paq.push(["setTrackerUrl", u+"piwik.php"]);
	    _paq.push(["setSiteId", "3"]);
	    var d=document, g=d.createElement("script"), s=d.getElementsByTagName("script")[0]; g.type="text/javascript";
	    g.defer=true; g.async=true; g.src=u+"piwik.js"; s.parentNode.insertBefore(g,s);
	  })();
	</script>
	<!-- End Piwik Code -->
</head>
<body class="preview" data-spy="scroll" data-target=".subnav" data-offset="80">
	<div class="container" itemscope itemtype="http://schema.org/Person">
		<header class="jumbotron">
			<div class="row">
				<div class="span12">
					<hgroup>
						<h1 style="padding: 10px 0; text-align: center; font-size: 60px" itemprop="name">František Eliáš</h1>
						<h2 style="text-align: center">curriculum vitae</h2>
					</hgroup>
					<address style="text-align: center"><br />
						<a href="http://blog.cinan.sk" target="_blank" itemprop="url">Blog</a><br />
						<a href="http://sk.linkedin.com/in/frantisekelias" itemprop="url" rel="me">LinkedIn</a><br /><br />
						<a href="mailto:elias.frantisek@gmail.com" itemprop="email">elias.frantisek@gmail.com</a><br />
						<a href="tel:+421949376613" itemprop="telephone">+421 949 376 613</a>
					</address>
				</div>
			</div> 
		</header>

		<section id="about">
			<div class="row">
				<div class="page-header">
					<h2>O mne</h2>
				</div>
			</div> 
			<div class="row" itemprop="description">
        <div class="span12">Pred <?= floor((time() - mktime(0,0,0, 7, 29, 1992)) / (60 * 60 * 24 * 365)) ?> rokmi som sa narodil Bardejove. Teraz žijem v Bratislave.</div>
        <div class="span12" style="padding-top: 12px">Programovaním sa živím od 20&dash;tich rokov.</div>
        <div class="span12" style="padding-top: 12px">Rád programujem webové služby a aplikácie. Začínal som s platformou Linux/BSD + Apache/Nginx + MySQL + PHP. V súčasnosti píšem webové/hybridné appky pre počítače a mobily v Darte a Javascripte. Sledujem najnovšie trendy a technológie, ktoré aj následne využívam.</div>
        <div class="span12" style="padding-top: 12px">
				Uznávam Lego. Neuznávam dotykové telefóny bez hardwarovej klávesnice. <br>Na internet nechodím, ja tu žijem.
        </div>
			</div>
		</section>

		<section id="experience">
			<div class="row">
				<div class="page-header">
					<h2>Zamestnania</h2>
				</div>
			</div>
			
			<section id="staffino" itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">Staffino</span> <a href="http://staffino.com/" target="_BLANK" itemprop="url" class="badge">Link</a><span class="visible-phone label pull-right">Júl 2014 &ndash; súčasnosť</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">Júl 2014 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Programátor</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Návrh, programovanie, štýlovanie a údržba webovej aplikácie a mobilnej hybridnej aplikácie Staffino pre manažérov. V staršej aplikácii som sa rozhodol pre AngularDart a v novšej som využil react.js.</li>
							<li>Plánovanie úloh a procesov s ostatnými členmi tímu</li>
              <li>Konfigurácia serverov cez Chef (Elasticsearch cluster + Logstash + Kibana, Nginx, Icinga, MediaWiki)</li>
                            <li>Nastavenie vývojového prostredia cez Vagrant</li>
                            <li>Prekladanie aplikácií pomocou Pootle a GNU gettext</li>
						</ul>
					</div>
				</div>
			</section>

			<section id="backbone" itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">Backbone s.r.o.</span> <a href="http://backbone.sk" target="_BLANK" itemprop="url" class="badge">Link</a><span class="visible-phone label pull-right">Júl 2012 &ndash; Január 2015</span>
</h4>
						</hgroup>
					</div>
					<div class="span4">
					  <span class="hidden-phone pull-right description">Júl 2012 &ndash; Január 2015</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Programátor</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
              <li>Programovanie stránok na zakázku na platforme Linux + Nginx + MySQL + PHP</li>  
              <li>Dlhodobý projekt &ndash; návrh a implementácia RESTful API spolu s webovým rozhraním pre telocvične (správa tréningov, kontrola dochádzky na tréningy, štatistiky, pokladňa, administrácia členov)</li>
              <li>Návrh API pre Týždeň.sk</li>
							<li>Práca v tíme</li>
						</ul>
					</div>
				</div>
			</section>

			<section itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">212 s.r.o.</span> <a href="http://212.sk" target="_BLANK" itemprop="url" class="badge">Link</a><span class="visible-phone label pull-right">Február 2012 &ndash; Apríl 2013</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">Február 2012 &ndash; Apríl 2013</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Webmaster</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Úprava webstránok podľa pokynov zadávateľa</li>
							<li>Spravovanie stránok bežiacich na Drupale</li>
							<li>Samostatná práca</li>
						</ul>
					</div>
				</div>
			</section>
		</section>
	      
		<section id="education">
			<div class="row">
				<div class="page-header">
					<h2>Vzdelanie</h2>
				</div>
			</div>
			
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>Fakulta hospodárskej informatiky, Ekonomická univerzita, Bratislava<span class="visible-phone label pull-right">2015 &ndash; súčasnosť</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">2015 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Informačný manažment, inžiniersky stupeň</div>
				</div>
			</section>
			<br>
			<section itemprop="alumniOf" itemscope itemtype="http://schema.org/CollegeOrUniversity">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4 itemprop="name">Fakulta matematiky, fyziky a informatiky, Univerzita Komenského, Bratislava<span class="visible-phone label pull-right">2010 &ndash; 2013</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">2010 &ndash; 2013</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Aplikovaná informatika, bakalársky stupeň</div>
				</div>
			</section>
			<br>
			<section itemprop="alumniOf" itemscope itemtype="http://schema.org/HighSchool">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4 itemprop="name">Osemročné gymnázium sv. Jána Bosca, Bardejov<span class="visible-phone label pull-right">2002 &ndash; 2010</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">2002 &ndash; 2010</span>
					</div>
				</div>
			</section>
		</section>

		<section id="courses">
			<div class="row">
				<div class="page-header">
					<h2>Kurzy a školenia</h2>
				</div>
			</div>
			
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>10gen Education <a href="https://education.10gen.com/" target="_BLANK" class="badge">Link</a><span class="visible-phone label pull-right">Október 2012 &ndash; December 2012</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">Október 2012 &ndash; December 2012</span>
					</div>
				</div>
				
				<div class="row">
					<div class="span6 description">MongoDB for Developers</div>
				</div>
			</section>
			<br>
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>Inštitút cudzích jazykov, Bardejov <a href="http://icj-bardejov.sk/" target="_BLANK" class="badge">Link</a><span class="visible-phone label pull-right">2006 &ndash; 2010</span></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="hidden-phone pull-right description">2006 &ndash; 2010</span>
					</div>
				</div>
				
				<div class="row">
					<div class="span6 description">Kurz anglického jazyka</div>
				</div>
			</section>
		</section>

		<section id="technical">
			<div class="row">
				<div class="page-header">
					<h2>Jazyky, frameworky, technológie</h2>
				</div>
			</div>
			<div class="row">
				<div class="span8">
					<?php
					iprogram('Dart','90');
          iprogram('Javascript/ECMAScript 6+','90');
					iprogram('React.js, AngularDart','90');
          iprogram('CSS/Stylus/Sass, BEM','85');
					iprogram('PHP','80');
          iprogram('MySQL','80');														
          iprogram('Grunt, Gulp, Webpack','75');														
          iprogram('Chart.js, D3.js','70');														
					iprogram('IndexedDB','60');
					iprogram('Chef','55');
					iprogram('MongoDB','50');
					iprogram('Ruby','40');
					iprogram('Java','35');
					iprogram('XSLT','30');
					iprogram('C++','30');
					iprogram('Haskell','20');
					iprogram('R','15');
					iprogram('Matlab','15');
					?>
				</div>
				<div class="span4">
					<div class="well"> 
						<h4>Vlastné a školské projekty</h4>
						<hr />
						<ul>
						<?= project('Bakalárska práca &ndash; XMPP (Jabber) chat so simulovanými MUC', 'Ruby (on Rails), MongoDB, Websocket, Backbone.js, SCSS') ?>
            <?= project('Administrácia tohto servera', 'GNU/Linux, Nginx, PHP, MySQL, git server, zálohovacie úložište, ownCloud, Octopress blog, Piwik') ?>
            <?= project('Bezdrôtová domácnosť s Raspberry Pi', 'automatické pravidelné zálohy, multimediálne centrum') ?>
						<?= project('Socket.IO pre Dart', 'Portovanie Socket.IO do Dartu s využitím dartovských idiómov') ?>
						</ul>
					</div>
				</div>
			</div>
		</section>      
		<section id="foreign-languages">
			<div class="row">
				<div class="page-header">
					<h2>Ľudské jazyky</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li><span title="Vyhral som 1. miesto v okresnom kole súťaže zo slovenskej gramatiky :)" style="border-bottom: 1px dotted #BBB">Slovenský jazyk</span> &ndash; materinský jazyk</li>
						<li>Anglický jazyk &ndash; aktívne</li>
						<li>Ruský jazyk &ndash; základy</li>
						<li>Francúzsky jazyk &ndash; základy</li>
					</ul>
				</div>
			</div>
		</section>
		<section id="driver-license">
			<div class="row">
				<div class="page-header">
					<h2>Vodičský preukaz</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li>Skupina B</li>
						<!--<li>A mozno tu pribude aj A skupina</li>-->
					</ul>
				</div>
			</div>
		</section>
		<section id="interests">
			<div class="row">
				<div class="page-header">
					<h2>Záľuby a koníčky</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
          Zaujímam sa o typografiu. Rád varím. Občas staviam Lego, prečítam alebo vypočujem si knihu alebo ešte radšej pozriem film. 
        </div>
			</div>
		</section>
		<footer>
			<small style="text-align: center; display: block;">František Eliáš, <?= date('Y') ?></small>
		</footer>
	</div>
</body>
</html>

<?php

function iprogram($language,$percent) {
	echo <<<EOD
<div class="row">
	<div class="span3">
		<h4 class="pagination-right pagination-left-mobile">$language</h4>
	</div>
	<div class="span4">
		<div class="progress">
			<div class="bar" style="width: $percent%"></div>
		</div>
	</div>
</div>
EOD;
	
}

function project($name, $technologies) {
	echo '<li style="padding-top: 12px">';
	
	if (!empty($look)) {
		echo '<a href="'.$look.'" target="_BLANK">'.$name.'</a>';
		echo '<br><span><em>'.$technologies.'</em></span>';
	} else {
		echo $name;
		echo '<br><span><em>'.$technologies.'</em></span>';
	}
	
	echo '</li>';
}
?>
