<!DOCTYPE html>
<html lang="sk">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="Curriculum Vitae - Frantisek Elias">
	<meta name="keywords" content="Frantisek, Elias, cv, zivotopis, curriculum vitae, bratislava, programator, php, student, developer, webdeveloper">
	<meta name="author" content="František Eliáš">
	<title>František Eliáš - Curriculum Vitae</title>
	
	<link href="/assets/css/bootstrap.css" rel="stylesheet">
	<link href="/assets/css/bootstrap-responsive.css" rel="stylesheet">

	<!--[if lt IE 9]>
	  <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
</head>
<body class="preview" data-spy="scroll" data-target=".subnav" data-offset="80">
	<div class="container" itemscope itemtype="http://schema.org/Person">
		<header class="jumbotron">
			<div class="row">
				<div class="span12">
					<hgroup>
						<h1 style="padding: 10px 0; text-align: center; font-size: 60px" itemprop="name">František Eliáš</h1>
						<h2 style="text-align: center">curriculum vitae</h2>
					</hgroup>
					<address style="text-align: center"><br />
						<a href="http://blog.cinan.sk" target="_blank" itemprop="url">Blog</a><br />
						<a href="http://sk.linkedin.com/in/frantisekelias" itemprop="url" rel="me">LinkedIn</a><br /><br />
						<a href="mailto:elias.frantisek@gmail.com" itemprop="email">elias.frantisek@gmail.com</a><br />
						<a href="tel:+421949376613" itemprop="telephone">+421 949 376 613</a>
					</address>

					<meta itemprop="jobTitle" content="Webdeveloper" />
					<meta itemprop="affiliation" content="Backbone s.r.o." />
				</div>
			</div> 
		</header>

		<section id="about">
			<div class="row">
				<div class="page-header">
					<h2>O mne</h2>
				</div>
			</div> 
			<div class="row" itemprop="description">
				<div class="span12">Pred <?= floor((time() - mktime(0,0,0, 7, 29, 1992)) / (60 * 60 * 24 * 365)) ?> rokmi som sa narodil Bardejove. Teraz žijem v Bratislave a študujem na Matfyze. Som v 4. ročníku odboru Aplikovaná informatika.
				<br>Rád programujem moderné webové stránky a aplikácie. Zvyčajne vyvíjam na platforme Linux/BSD + Apache/Nginx + Mysql + PHP, ale mám skúsenosti aj s RoR aplikáciami a NoSQL databázami. 
				<br>
				<br>Uznávam Lego. Neuznávam dotykové telefóny.
				<br>Na internet nechodím, ja tu žijem.
				</div>
			</div>
		</section>

		<section id="education">
			<div class="row">
				<div class="page-header">
					<h2>Vzdelanie</h2>
				</div>
			</div>
			
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>Fakulta matematiky, fyziky a informatiky, Univerzita Komenského, Bratislava</h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2013 &ndash; súčasnosť</span>
						<span class="hidden-phone pull-right description">2013 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Aplikovaná informatika, magisterský stupeň (zameranie počítačová grafika)</div>
				</div>
			</section>
			<br>
			<section itemprop="alumniOf" itemscope itemtype="http://schema.org/CollegeOrUniversity">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4 itemprop="name">Fakulta matematiky, fyziky a informatiky, Univerzita Komenského, Bratislava</h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2010 &ndash; 2013</span>
						<span class="hidden-phone pull-right description">2010 &ndash; 2013</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Aplikovaná informatika, bakalársky stupeň</div>
				</div>
			</section>
			<br>
			<section itemprop="alumniOf" itemscope itemtype="http://schema.org/HighSchool">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4 itemprop="name">Osemročné gymnázium sv. Jána Bosca, Bardejov</h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2002 &ndash; 2010</span>
						<span class="hidden-phone pull-right description">2002 &ndash; 2010</span>
					</div>
				</div>
			</section>
		</section>

		<section id="courses">
			<div class="row">
				<div class="page-header">
					<h2>Kurzy a školenia</h2>
				</div>
			</div>
			
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>10gen Education <a href="https://education.10gen.com/" target="_BLANK"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Október 2012 &ndash; December 2012</span>
						<span class="hidden-phone pull-right description">Október 2012 &ndash; December 2012</span>
					</div>
				</div>
				
				<div class="row">
					<div class="span6 description">MongoDB for Developers</div>
				</div>
			</section>
				
			<section>
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4>Inštitút cudzích jazykov, Bardejov <a href="http://icj-bardejov.sk/" target="_BLANK"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">2006 &ndash; 2010</span>
						<span class="hidden-phone pull-right description">2006 &ndash; 2010</span>
					</div>
				</div>
				
				<div class="row">
					<div class="span6 description">Kurz anglického jazyka</div>
				</div>
			</section>
		</section>

		<section id="experience">
			<div class="row">
				<div class="page-header">
					<h2>Zamestnania</h2>
				</div>
			</div>

			<section id="backbone" itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">Backbone s.r.o.</span> <a href="http://backbone.sk" target="_BLANK" itemprop="url"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Júl 2012 &ndash; súčasnosť</span>
						<span class="hidden-phone pull-right description">Júl 2012 &ndash; súčasnosť</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Programátor</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Programovanie stránok na zakázku</li>
							<li>Používané technológie: PHP (firemný MVC framework), Javascript/Coffeescript, MySQL, Twig, SCSS, Capistrano, Svn, Git</li>
							<li>Práca v tíme</li>
						</ul>
					</div>
				</div>
			</section>

			<section itemprop="worksFor" itemscope itemtype="http://schema.org/LocalBusiness">
				<div class="row">
					<div class="span8">
						<hgroup>
							<h4><span itemprop="name">212 s.r.o.</span> <a href="http://212.sk" target="_BLANK" itemprop="url"><span class="badge">Link <span class="icon-arrow-right icon-white" style="margin-top:0"></span></span></a></h4>
						</hgroup>
					</div>
					<div class="span4">
						<span class="visible-phone label">Február 2012 &ndash; Apríl 2013</span>
						<span class="hidden-phone pull-right description">Február 2012 &ndash; Apríl 2013</span>
					</div>
				</div>
				<div class="row">
					<div class="span6 description">Webmaster</div>
				</div>
				<div class="row" style="padding-top: 8px;">
					<div class="span12">
						<ul>
							<li>Úprava webstránok podľa pokynov zadávateľa</li>
							<li>Spravovanie stránok bežiacich na Drupale</li>
							<li>Samostatná práca</li>
						</ul>
					</div>
				</div>
			</section>
		</section>
	      
		<section id="technical">
			<div class="row">
				<div class="page-header">
					<h2>Jazyky a technológie</h2>
				</div>
			</div>
			<div class="row">
				<div class="span8">
					<?
					iprogram('PHP','85');
					iprogram('Ruby','50');
					iprogram('Javascript/Coffeescript','65');
					iprogram('MySQL','80');
					iprogram('MongoDB','50'); 
					iprogram('CSS','60');
					iprogram('Git','70');
					iprogram('Bash','70');
					iprogram('C++','30');
					iprogram('Java','35');
					iprogram('Matlab','20');
					iprogram('Haskell','25');
					?>
				</div>
				<div class="span4">
					<div class="well">
						<h4>Vlastné a školské projekty</h4>
						<hr />
						<ul>
						<?= project('Bakalárska práca &ndash; XMPP (Jabber) chat so simulovanými MUC', 'Ruby (on Rails), MongoDB, <strong>Websocket</strong>, <strong>Backbone.js</strong>, SCSS', 'http://chat.cinan.sk','http://git.cinan.sk/xmpp-bachelor.git/') ?>
						<?= project('Administrácia tohto servera', 'GNU/Linux, Nginx, PHP, MySQL, MongoDB, Ruby on Rails aplikácie, Git server, zálohovacie úložište, ownCloud, Octopress blog, Capistrano', '', '') ?>
						</ul>
						<a class="pull-right btn btn-small btn-inverse" href="http://git.cinan.sk">Môj Git <i class="icon-arrow-right icon-white"></i></a><br />
					</div>
				</div>
			</div>
		</section>      
		<section id="foreign-languages">
			<div class="row">
				<div class="page-header">
					<h2>Jazykové znalosti</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li><span title="Vyhral som 1. miesto v okresnom kole súťaže zo slovenskej gramatiky :)" style="border-bottom: 1px dotted #BBB">Slovenský jazyk</span> &ndash; materinský jazyk</li>
						<li>Anglický jazyk &ndash; aktívne</li>
						<li>Ruský jazyk &ndash; základy</li>
						<li>Francúzsky jazyk &ndash; základy</li>
					</ul>
				</div>
			</div>
		</section>
		<section id="driver-license">
			<div class="row">
				<div class="page-header">
					<h2>Vodičský preukaz</h2>
				</div>
			</div> 
			<div class="row">
				<div class="span12">
					<ul>
						<li>Skupina B</li>
						<!--<li>A mozno tu pribude aj A skupina</li>-->
					</ul>
				</div>
			</div>
		</section>
		<footer>
			<small style="text-align: center; display: block;">František Eliáš, <?= date('Y') ?></small>
		</footer>
	</div>
</body>
</html>

<?php

function iprogram($language,$percent) {
	echo <<<EOD
<div class="row">
	<div class="span3">
		<h4 style="text-align: right" class="hidden-phone">$language</h4>
		<span class="badge visible-phone" style="text-align: center">$language</span>
	</div>
	<div class="span4">
		<div class="progress" style="margin: 10px 0 10px 0; height: 22px;">
			<div class="bar" style="width: $percent%;"></div>
		</div>
	</div>
</div>
EOD;
	
}

function project($name, $technologies, $look, $code) {
	echo '<li style="padding-top: 12px">';
	
	if (!empty($look)) {
		echo '<a href="'.$look.'" target="_BLANK">'.$name.'</a>';
		echo '<br><span>'.$technologies.'</span>';
	} else {
		echo $name;
		echo '<br><span>'.$technologies.'</span>';
	}
	
	if (!empty($code)) {
		echo ' <a href="'.$code.'" target="_BLANK"><span class="pull-right badge badge-info">Zdrojáky <i class="icon-arrow-right icon-white"></i></span></a>';
	}
	echo '</li>';
}
?>
